#!/usr/bin/python

# dependencies - visualization of source code dependencies
# Copyright (C) 2009-2022  Joachim Reichel <joachim.reichel@posteo.de>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

'''Splits strongly connected components into separate files.

Postprocesses the output of sccmap by contracting strongly connected
components (SCCs) into separate .dot files. The sccmap command should not be
called with the -d parameter to suppress SCCs of size 1. The generated files
are named $1-scc<N>.dot.'''

import sys


def main():
    '''Splits strongly connected components into separate files.'''
    count = 0
    reopen = True
    file = None

    for line in sys.stdin:

        line = line.rstrip()
        if line == "digraph scc_map {":
            break

        if reopen:
            file = open("scc%d.dot" % count, 'w')
            print("Reopening %d"%count)
            reopen = False

        print(line, file=file)

        if line == "}":
            count += 1
            reopen = True


if __name__ == "__main__":
    main()
